<?php
require('fpdf/rotate.php');
error_reporting(E_ALL & ~E_NOTICE);
class PDF extends PDF_Rotate
{
// Load data
function LoadData($file)
{
    // Read file lines
    $lines = file($file);
    $data = array();
    foreach($lines as $line)
        $data[] = explode(';',trim($line));
    return $data;
}
function Header(){
    if($this->PageNo()>1){
        $this->writeRecordHeading();
    }

}

function RotatedText($x, $y, $txt, $angle)
{
    //Text rotated around its origin
    $this->Rotate($angle,$x,$y);
    $this->Text($x,$y,$txt);
    $this->Rotate(0);
}


function Footer()
{
    // Position at 1.5 cm from bottom
    $this->SetY(-15);
    // Arial italic 8
    $this->SetFont('Arial','i',6);
    // Page number
    date_default_timezone_set('UTC');
    $this->Cell(0,10,'HMS: Condition Report  '.date('d-m-Y H:i:s'),0,0,'L');
    $this->Cell(0,10,$this->PageNo().' of {nb}',0,0,'R');
    //$this->SetFont('Arial','B',50);
    //$this->SetAlpha(0.6);
    //$this->SetTextColor(255,142,153);
    //$this->RotatedText(70,190,'D R A F T',45);
    //$this->SetAlpha(1);
    $this->SetFont('Arial','B',6);
}


function writeIntro($vals){

    $this->SetFont('Arial','',14);
    $this->AddPage();
    $this->SetTextColor(128,169,136);
    $this->SetDrawColor(255);
    
    $this->SetFont('','B');
    $this->ln();
    $this->ln();
    $this->Cell(0,10,'HMS: CONDITION REPORT',0,1,'C');
    $this->SetFont('Arial','B',8);
    $this->SetTextColor(128,169,136);
    $this->Cell(0,10,'SEARCH CRITERIA',0,0,'L');
    $this->Ln(7);
    $this->SetTextColor(255);
    $this->SetFillColor(128,169,136);
    $this->Cell(64,5,'Type/Variant',1,0,'L',true);
    $this->Cell(64,5,'VRN',1,0,'L',true);
    $this->Ln(5);
    $this->SetTextColor(0);
    $this->SetFillColor(181,220,185);
    $this->SetFont('Arial','B',8);
    $this->Cell(64,4,$_POST['_vehicleid'],'LR',0,'L',true);
    $this->Cell(64,4,$_POST['_vrn'],'LR',0,'L',true);

    $this->Ln(7);

    $this->SetTextColor(255);
    $this->SetFillColor(128,169,136);
    $this->Cell(64,5,'Unit/Location',1,0,'L',true);
    $this->Cell(64,5,'Status',1,0,'L',true);
    $this->Cell(64,5,'Score',1,0,'L',true);
    $this->Ln(5);
    $this->SetTextColor(0);
    $this->SetFillColor(181,220,185);
    $this->SetFont('Arial','B',8);
    $this->Cell(64,4,$_POST['_holdingUnit'],'LR',0,'L',true);
    $this->Cell(64,4,$_POST['_status'],'LR',0,'L',true);
        $score=$_POST['_score']!==""?$_POST['_scoretype']." : ".$_POST['_score']:"";
    $this->Cell(64,4,$score,'LR',0,'L',true);

    $this->Ln(7);
    $this->SetFont('Arial','B',8);
    $this->SetTextColor(128,169,136);
    $this->Cell(0,10,'RESULTS',0,0,'L');
    $this->Ln(7);
    $this->writeRecordHeading();
}

function writeRecordHeading(){

    $this->SetFont('Arial','B',6);
    $this->SetTextColor(0);
    $this->SetFillColor(181,220,185);
    $this->SetDrawColor(0);
    $this->Cell(10,5,'#','LRT',0,'L',true);
    $this->Cell(22,5,'VRN','LRT',0,'L',true);
    $this->Cell(32,5,'Unit','LRT',0,'L',true);
    $this->Cell(32,5,'Overall Score','LRT',0,'L',true);
    $this->Cell(32,5,'Mission Score','LRT',0,'L',true);
    $this->Cell(32,5,'Safety Score','LRT',0,'L',true);
    $this->Cell(32,5,'Status','LRT',0,'L',true);
    $this->Ln(5);
}


}
$statusmap=array("","Fully operational","Limited role","Non operational");
$pdf = new PDF();
$pdf->AliasNbPages();
//$vals=json_decode($json,true);
$pdf->writeIntro($_POST);
$pdf->SetFont('Arial','B',6);
$pdf->SetTextColor(0);
$pdf->SetFillColor(255);
$pdf->SetDrawColor(0);
$pdf->tablewidths = array(10, 22, 32, 32, 32, 32, 32);
for($i=0;$i<count($_POST['id']);$i++) {
    $data[] = array($_POST['version'][$i], $_POST['vrn'][$i], $_POST['unit'][$i],$_POST['overallscore'][$i], $_POST['missionscore'][$i], $_POST['safetyscore'][$i],$statusmap[$_POST['status'][$i]]);
}
$pdf->morepagestable($data,3);

$pdf->Output();
exit;
?>